<?php
/*
 * Copyright 2014 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

namespace Google\Service\Forms;

class BatchUpdateFormResponse extends \Google\Collection
{
  protected $collection_key = 'replies';
  /**
   * @var Form
   */
  public $form;
  protected $formType = Form::class;
  protected $formDataType = '';
  /**
   * @var Response[]
   */
  public $replies;
  protected $repliesType = Response::class;
  protected $repliesDataType = 'array';
  /**
   * @var WriteControl
   */
  public $writeControl;
  protected $writeControlType = WriteControl::class;
  protected $writeControlDataType = '';

  /**
   * @param Form
   */
  public function setForm(Form $form)
  {
    $this->form = $form;
  }
  /**
   * @return Form
   */
  public function getForm()
  {
    return $this->form;
  }
  /**
   * @param Response[]
   */
  public function setReplies($replies)
  {
    $this->replies = $replies;
  }
  /**
   * @return Response[]
   */
  public function getReplies()
  {
    return $this->replies;
  }
  /**
   * @param WriteControl
   */
  public function setWriteControl(WriteControl $writeControl)
  {
    $this->writeControl = $writeControl;
  }
  /**
   * @return WriteControl
   */
  public function getWriteControl()
  {
    return $this->writeControl;
  }
}

// Adding a class alias for backwards compatibility with the previous class name.
class_alias(BatchUpdateFormResponse::class, 'Google_Service_Forms_BatchUpdateFormResponse');
