<?php
/*
 * Copyright 2014 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

namespace Google\Service\Contentwarehouse;

class AppsPeopleOzExternalMergedpeopleapiCustomSchemaField extends \Google\Model
{
  /**
   * @var string
   */
  public $fieldDisplayName;
  /**
   * @var string
   */
  public $fieldId;
  /**
   * @var string
   */
  public $fieldType;
  /**
   * @var string
   */
  public $formattedType;
  /**
   * @var AppsPeopleOzExternalMergedpeopleapiPersonFieldMetadata
   */
  public $metadata;
  protected $metadataType = AppsPeopleOzExternalMergedpeopleapiPersonFieldMetadata::class;
  protected $metadataDataType = '';
  /**
   * @var bool
   */
  public $multiValued;
  /**
   * @var string
   */
  public $schemaDisplayName;
  /**
   * @var string
   */
  public $schemaId;
  /**
   * @var string
   */
  public $type;
  /**
   * @var string
   */
  public $value;

  /**
   * @param string
   */
  public function setFieldDisplayName($fieldDisplayName)
  {
    $this->fieldDisplayName = $fieldDisplayName;
  }
  /**
   * @return string
   */
  public function getFieldDisplayName()
  {
    return $this->fieldDisplayName;
  }
  /**
   * @param string
   */
  public function setFieldId($fieldId)
  {
    $this->fieldId = $fieldId;
  }
  /**
   * @return string
   */
  public function getFieldId()
  {
    return $this->fieldId;
  }
  /**
   * @param string
   */
  public function setFieldType($fieldType)
  {
    $this->fieldType = $fieldType;
  }
  /**
   * @return string
   */
  public function getFieldType()
  {
    return $this->fieldType;
  }
  /**
   * @param string
   */
  public function setFormattedType($formattedType)
  {
    $this->formattedType = $formattedType;
  }
  /**
   * @return string
   */
  public function getFormattedType()
  {
    return $this->formattedType;
  }
  /**
   * @param AppsPeopleOzExternalMergedpeopleapiPersonFieldMetadata
   */
  public function setMetadata(AppsPeopleOzExternalMergedpeopleapiPersonFieldMetadata $metadata)
  {
    $this->metadata = $metadata;
  }
  /**
   * @return AppsPeopleOzExternalMergedpeopleapiPersonFieldMetadata
   */
  public function getMetadata()
  {
    return $this->metadata;
  }
  /**
   * @param bool
   */
  public function setMultiValued($multiValued)
  {
    $this->multiValued = $multiValued;
  }
  /**
   * @return bool
   */
  public function getMultiValued()
  {
    return $this->multiValued;
  }
  /**
   * @param string
   */
  public function setSchemaDisplayName($schemaDisplayName)
  {
    $this->schemaDisplayName = $schemaDisplayName;
  }
  /**
   * @return string
   */
  public function getSchemaDisplayName()
  {
    return $this->schemaDisplayName;
  }
  /**
   * @param string
   */
  public function setSchemaId($schemaId)
  {
    $this->schemaId = $schemaId;
  }
  /**
   * @return string
   */
  public function getSchemaId()
  {
    return $this->schemaId;
  }
  /**
   * @param string
   */
  public function setType($type)
  {
    $this->type = $type;
  }
  /**
   * @return string
   */
  public function getType()
  {
    return $this->type;
  }
  /**
   * @param string
   */
  public function setValue($value)
  {
    $this->value = $value;
  }
  /**
   * @return string
   */
  public function getValue()
  {
    return $this->value;
  }
}

// Adding a class alias for backwards compatibility with the previous class name.
class_alias(AppsPeopleOzExternalMergedpeopleapiCustomSchemaField::class, 'Google_Service_Contentwarehouse_AppsPeopleOzExternalMergedpeopleapiCustomSchemaField');
