<?php

ini_set('display_errors', '1');
ini_set('display_startup_errors', '1');
error_reporting(E_ALL);



// Function to check database connection
function checkDatabaseConnection() {

    $servername = "localhost";
$username = "admin";
$password = "b3ddebe85e9c5555dc07d5a0f51171ed325b87286f6a8aed";
$dbname = "dev";

    // Create connection
    $conn = new mysqli($servername, $username, $password, $dbname);

    // Check connection
    if ($conn->connect_error) {
        return ["status" => "failed", "message" => "Database connection failed: " . $conn->connect_error];
    } else {
        $conn->close();
        return ["status" => "success", "message" => "Database connection successful"];
    }
}

// Function to check Socket.IO connection
function checkSocketIOConnection() {
    $url = "https://desiredatings.app:4004";

    $ch = curl_init($url);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    $response = curl_exec($ch);
    $httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);

    if ($httpCode != 200) {
        return ["status" => "failed", "message" => "Socket.IO connection failed: HTTP Code $httpCode"];
    } else {
        return ["status" => "success", "message" => "Socket.IO connection successful"];
    }
}

// Function to check Google Geocode API
function checkGeocodeAPI() {
    $apiKey = "AIzaSyDjLr5V1I50ocCA-uKX_9TYpNgYOc0Oqxs";
    $address = "Simla Ghoshpara";
    $url = "https://maps.googleapis.com/maps/api/geocode/json?address=" . urlencode($address) . "&key=" . $apiKey;

    $ch = curl_init($url);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    $response = curl_exec($ch);
    $httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
    curl_close($ch);

    if ($httpCode != 200) {
        return ["status" => "failed", "message" => "Google Geocode API connection failed: HTTP Code $httpCode"];
    } else {
        $data = json_decode($response, true);
        if ($data['status'] != "OK") {
            return ["status" => "failed", "message" => "Google Geocode API connection failed: " . $data['status']];
        } else {
            return ["status" => "success", "message" => "Google Geocode API connection successful"];
        }
    }
}

// Perform checks
$dbCheck = checkDatabaseConnection();
$socketCheck = checkSocketIOConnection();
$geocodeCheck = checkGeocodeAPI();

$checks = [
    "Database Connection" => $dbCheck,
    "Socket.IO Connection" => $socketCheck,
    "Google Geocode API" => $geocodeCheck
];

// Generate HTML table
$htmlTable = "<table border='1' style='border-collapse: collapse; width: 100%;'>
<tr>
    <th>Check</th>
    <th>Status</th>
    <th>Message</th>
</tr>";

foreach ($checks as $checkName => $result) {
    $statusColor = $result['status'] == "success" ? "green" : "red";
    $htmlTable .= "<tr>
        <td>$checkName</td>
        <td style='color: $statusColor;'>{$result['status']}</td>
        <td>{$result['message']}</td>
    </tr>";
}

$htmlTable .= "</table>";

echo $htmlTable;

// Send alert if there are failures
/*if ($alertMessage != "") {
    mail("your_email@example.com", "Server Health Check Alert", $alertMessage);
}*/

// echo "Health checks completed.";
?>